function arfr(m,q,x)

% fonction arfr(m,q,x)
% Cette fonction affiche les graphes de 
% la racine carree de la densite spectrale de 
% puissance (sur [0:pi]) des trois premiers details 
% de la decomposition de Franklin d'un signal x 
% de longueur 2^q+1. La racine carree de la 
% densite spectrale de puissance est en jaune, les 
% racines des densites spectrales de puissance de d1,d2,d3
% sont respectivement en rouge, bleu, vert. 
% Le nombre m est le nombre de parametres avec 
% lequel est implemente l'algorithme auto-regressif.  


i=1:m;
y=autoreg2(m,x);
r1=franklin(0,q,x);
d1=x-r1;
y1=autoreg2(m,d1);
r2=franklin(1,q,r1);
d2=r1-r2;
y2=autoreg2(m,d2);
r3=franklin(2,q,r2);
d3=r2-r3;
y3=autoreg2(m,d3);
plot(i,y,'y-', i,y1,'r-', i,y2,'b-', i,y3,'g-')