function f=autoreg3(m,pas,s,sigma);

%  f=autoreg3(m,pas,s,sigma)
%Affiche la densite spectrale de puissance d'un signal s
%calculee avec l'algorithme auto-regressif a m-1 parametres
%et affiche avec un pas donne. Le nombre sigma represente 
%un seuil de tolerance au niveau de la division (rapprt bruit/signal). 

u=autoreg1(m,s);
omega=0:pas:pi;
L=length(omega);
S=zeros(m,L);
for j=2:m
   S(j,:)=-u(j)*exp(-i*(j-1)*omega);
end
S(1,:)=ones(1,L);
v=(abs (sum(S))).^2;
v=v+(sigma^2)*ones(1,L);
f=1./v; 
