function f=autoreg4(s,m,p,tau,q,sigma);

% f=autoreg4(s,m,p,tau,q,sigma);
%Calcule la densite spectrale de puissance glissante (calculee via l'algorithme AR 
%avec q parametres d'autoregressivite), la fenetre etant de longueur 
%m et le pas (entier) de deplacement de p; ''tau'' designe le pas (reel) auquel est 
%echantillonne l'intervalle frequentiel [0,pi].La quantite sigma represente 
%le seuil de tolerance dans la division conduisant a l'expression de la 
%densite spectrale de puissance (voir AUTOREG3). 


N=length (s);
t=1:p:N-m; 
omega=0:tau:pi;
N1=length(t);
M1=length(omega);
A=zeros(M1,N1);
y=zeros(1,M1);
for k=1:N1, 
    z=s(k*p-(p-1):k*p+m-p);
    y=autoreg3(q,tau,z,sigma);
    A(:,k)=y';
 end; 
 f=A;