function [f1,f2]=autoreg5(m, s,pas);

%[f1,f2]=autoreg5(m, s,pas)
%Calcule le logarithme (ici f2) de la densite spectrale de puissance   
%d'un signal s calculee avec l'algorithme auto-regressif a m-1 parametres; 
%les valeurs sont calculees sue l'intervalle [pas,pi] echantillone avec le pas ``pas''; 
%le vecteur f1 represente les valeurs de log (omega), omega=pas:pas:pi. 
%la commande plot(f1,f2) permet donc la representation graphique du logarithme de 
%la densite spectrale de puissance de s comme fonction du logarithme de la frequence; 
%ce programme a ete concu pour l'etude frequentielle statistique des signaux de 
%turbulence (validation des lois de Kolmogorov, etc...)

u=autoreg1(m,s);
omega=pas:pas:pi;
f1=log(omega);
L=length(omega);
S=zeros(m,L);
for j=2:m
   S(j,:)=-u(j)*exp(-i*(j-1)*omega);
end
S(1,:)=ones(1,L);
vv=abs (sum(S));
f2=-log (vv); 
