function f=autoreg6(s,m,p,sigma,tau,q);

% f=autoreg6(s,m,p,sigma,tau,q);
%Calcule le logarithme de la densite spectrale de puissance glissante (calculee via l'algorithme AR 
%avec m-1 parametres d'autoregressivite) en fonction du logarithme de la frequence, la fenetre etant de longueur 
%q et le pas (entier) de deplacement de p; ''sigma'' designe le pas (reel) auquel est 
%echantillonne l'intervalle frequentiel [log(tau),log(pi)]. 


N=length (s);
t=1:p:N-q; 
omega=log(tau):sigma:log(pi);
Omega=exp(omega);
N1=length(t);
M1=length(Omega);
A=zeros(M1,N1);
y=zeros(1,M1);
for k=1:N1, 
    z=s(k*p-(p-1):k*p+q-p);
    y=autoreg_aux(m,z,Omega);
    A(:,k)=y';
 end; 
 f=A;