function R=covar(N,s);

% R=covar(N,s);
% Calcule la matrice de correlation d'un signal s
% digital donne sur (1,...,M), de taille (1,M).
% La sortie f est une matrice de taille (N,N)  
% dont les coefficients sont les R_(s,s) (k1,k2), 0=<k1,k2<= N-1
% On doit avoir 2(N-1)<M. 


A=zeros(N,N);
t=zeros(N,N);
for k=0:(N-1), 
  for j=1:N, 
    t(j,k+1)=(1/N)*(s(k+1+N-j));
    
  end
end

B=N*(t*t');
for i=0:(N-1)
  for j=0:(N-1)
    A(i+1,j+1)=B(N-i,N-j);
  end
end
R=A;