function CWT = cwt(s,n_voix,ondelette)

% CWT=cwt(s,n_voix,ondelette);
%Calcule la transformee en ondelettes continue 
%d'un signal $s$ de longueur n=2^p 
%Les 7 ondelettes possibles sont 
%'Chaary', 'Franklin', 'Gabor', 'Gauss', 
%'Morlet', 'Sombrero#', 'Spline#'; 
% En sortie:
% CWT      matrice n by n_echelle ou
%             n_echelles = n_voix .* n_octaves
%
%Les valeurs du parametre a d'echelle 
%sont telles que log_2(a) est entre 2 et p.  


b=min(6,length(ondelette));
b1=min(8,length(ondelette));
x=s(:)';
n=length(x);
xhat=fft(x);
xi   = [ (0: (n/2)) (((-n/2)+1):-1) ] .* (2*pi);
	Gauss    = 0;
	Sombrero = 0;
	Morlet   = 0;
	Chaary	 = 0;
        Gabor    = 0;
        Spline   = 0;
        Franklin = 0;

if	strcmp(ondelette,'Gauss'),
		Gauss    = 1;
elseif	strcmp(ondelette(1:b1),'Sombrero'),
		Sombrero = 1;
		enne = str2num(ondelette(9:length(ondelette)));
elseif	strcmp(ondelette,'Morlet'),
		Morlet   = 1;	
		omega0  = pi*sqrt(2/log(2)); 
elseif  strcmp(ondelette(1:b),'Spline'),
		Spline	 = 1;
		enne = str2num(ondelette(7:length(ondelette)));
		a = 0.697066; sigma = 0.561145;
		omega0 = 0.409177/(2*pi);
		beta   = 2*sigma*(enne+1);
elseif	strcmp(ondelette,'Chaary'),
		Chaary	 = 1;	beta = (2*pi).^2/6;
		alpha = sqrt(2*beta);
elseif	strcmp(ondelette,'Gabor'),
		Gabor	 = 1;  w0=5.33644;
elseif	strcmp(ondelette,'Franklin'),
		Franklin = 1;  
else error('Usage cwt: Chaary|Franklin|Gabor|Gauss|Morlet|Sombrero#|Spline#|');
	end	

n_octaves=floor(log2(n))-1;
n_echelles= n_voix .* n_octaves;
	
k_echelle=1;
echelle=4;
CWT = zeros(n,n_echelles);


for j=1:n_octaves,
	    for l=0:n_voix-1,
		   q_echelle=echelle .* (2^(l/n_voix));
		   omega=xi ./q_echelle;


if     Gauss,
  psi_hat=exp(-omega.^2 ./2);
elseif Sombrero,
  psi_hat=((omega/2).^enne) .* exp(-(omega/2).^2 ./2);
elseif Morlet,
  psi_hat=exp(-(omega - omega0).^2 ./2) - exp(-(omega.^2 + omega0.^2)/2);
elseif Spline

  psi_hat=real(((1-exp(-i*(omega+.01)/16))./(i*(omega+.01)/16)).^enne);
elseif Chaary
  psi_hat=2*(2*omega-2*pi).^2.*(2*alpha.^3-6*beta.*alpha);
  psi_hat=psi_hat+2*(2*alpha.^5+2*beta*alpha.^3);
  psi_hat=psi_hat./(alpha.^2+4*(omega-pi).^2).^3;
elseif Gabor
  psi_hat=exp(-(omega-w0).^2 ./2);
elseif Franklin
  p1=cos(pi*omega/16);
  p2=(sin(pi*omega/16)).^2;
  p3=2-cos(pi*omega/16);
  p4=(2+cos(pi*omega/16)).*(2+cos(pi*omega/8));
  p5=(sinc(omega/8)).^2;
  psi_hat=p1.*p2.*(sqrt(p3./p4)).*p5;
end
w_hat=xhat.*psi_hat; 
w=ifft(w_hat);	
CWT(1:n,k_echelle)=(w)';
k_echelle=k_echelle+1;
end
echelle=echelle .*2;
%plot(real(psi_hat));
%hold on
%pause(2)
end 

		    
    
