function f=daub4(s);

%function f=daub4(s);
%cette fonction affiche les listes de 
%coefficients correspondant a 5 niveaux de 
%details pour l'analyse de Daubechies 
%a 4 parametres du signal s-mean(s).
%La longueur de s est 2^q, g=>5.

M=length(s);
y=s-mean(s);
i=1:M;
d1=ddaub4t(y);
dd1=dilate(d1,1);
q1=dd1(3:M);
m1=max(abs(q1));
r1=rdaub4t(y);
d2=ddaub4t(r1);
dd2=dilate(d2,2);
q2=dd2(5:M);
m2=max(abs(q2));
r2=rdaub4t(r1);
d3=ddaub4t(r2);
dd3=dilate(d3,3);
q3=dd3(9:M);
m3=max(abs(q3));
r3=rdaub4t(r2);
d4=ddaub4t(r3);
dd4=dilate(d4,4);
q4=dd4(17:M);
m4=max(abs(q4));
r4=rdaub4t(r3);
d5=ddaub4t(r4);
dd5=dilate(d5,5);
q5=dd5(33:M);
m5=max(abs(q5));
M2=m1+m2;
M3=M2+m2+m3;
M4=M3+m3+m4;
M5=M4+m4+m5;
plot(i,dd1,'y-',i,dd2+M2,'r-', i,dd3+M3,'b-', i,dd4+M4, 'g-', i, dd5+M5, 'c-');
hold
u=ones(1,M);
plot(i,zeros(1,M),'k:', i, M2*u, 'k:', i,M3*u,'k:',i,M4*u,'k:',i,M5*u,'k:');
axis([1 M -(3/2)*m1 M5+(3/2)*m5])
gy=get(gca,'Ylim');
ly=gy(1);
hy=gy(2);
v=['d' '1' ' ' ' ';
   'd' '2' ' ' ' ';
   'd' '3' ' ' ' ';
   'd' '4' ' ' ' ';
   'd' '5' ' ' ' ';];
vet=[0 M2 M3 M4 M5];
set(gca,'Ylim',[ly hy],'YTick',vet,'YTickLabels',v);
set(gca,'XColor','w');
hold


