function [R,Dobl,Dvert,Dhor,m1,m2]=daub8_2D(A);

% [R,Dobl,Dvert,Dhor]=daub8_2D(A);
%algorithme de filtrage+decimation 
%correspondant a l'analyse 
%multiresolution de Daubechies 
%a 8 parametres 2 dimensionnelle
%(version non decalee implementee 
%dans l'algorithme de splitting)
%Les quatre images ( m1 lignes et m2 colonnes) 
%obtenues correspondent (dans cet ordre) 
%au resume, aux details obliques, 
%aux details horizontaux, aux details verticaux.   

[N1,N2]=size(A);

h=ones(1,8);
g=zeros(1,8);

h(1)=.230378;
h(2)=.714846;
h(3)=.630881;
h(4)=-.027984;
h(5)=-.187035;
h(6)=.030841;
h(7)=.032883;
h(8)=-.010597;

g(1)=-h(8);
g(2)=h(7);
g(3)=-h(6);
g(4)=h(5);
g(5)=-h(4);
g(6)=h(3);
g(7)=-h(2);
g(8)=h(1);

HR=h'*h;
Hobl=g'*g;
Hvert=h'*g;
Hhor=g'*h;

R=conv2(A,HR);
Dobl=conv2(A,Hobl);
Dvert=conv2(A,Hvert);
Dhor=conv2(A,Hhor); 

m1=fix((N1+7)/2);
m2=fix((N2+7)/2); 

u=ones(m1,m2);
for l1=1:m1
   for l2=1:m2
      uR(l1,l2)=R(2*(l1)-1,2*(l2)-1);
      uDobl(l1,l2)=Dobl(2*(l1)-1,2*(l2)-1);
      uDvert(l1,l2)=Dvert(2*(l1)-1,2*(l2)-1);
      uDhor(l1,l2)=Dhor(2*(l1)-1,2*(l2)-1);
   end
end
if mod(m1,2) == 0
   R=uR;
   Dobl=uDobl;
   Dvert=uDvert;
   Dhor=uDhor;
else
   R=[uR;zeros(1,m2)];
   Dobl=[uDobl;zeros(1,m2)];
   Dvert=[uDvert;zeros(1,m2)];
   Dhor=[uDhor;zeros(1,m2)];
end
[m1,m2]=size(R);
if mod(m2,2) == 0
   R=R;
   Dobl=Dobl;
   Dvert=Dvert;
   Dhor=Dhor;
else
   R=[R zeros(m1,1)];
   Dobl=[Dobl zeros(m1,1)];
   Dvert=[Dvert zeros(m1,1)];
   Dhor=[Dhor zeros(m1,1)];
end
[m1,m2]=size(R);
   


