function [R,Dobl,Dvert,Dhor,decomp]=daub8t_2D(A);

% [R,Dobl,Dvert,Dhor,decomp]=daub8t_2D(A);
%Decomposition 2D (tronque) suivant l'analyse 
%multiresolution de Daubechies (8 parametres)
%R designe le resume
%Dobl designe les details obliques
%Dvert designe les details verticaux 
%Dhor designe les details verticaux 


N=size(A,1);
m=fix((N+1)/2);

R=ones(m,m);
Dobl=ones(m,m);
Dvert=ones(m,m);
Dhor=ones(m,m);

h=zeros(1,14);
g=zeros(1,14);
h(8)=.230378;
h(7)=.714846;
h(6)=.630881;
h(5)=-.027984;
h(4)=-.187035;
h(3)=.030841;
h(2)=.032883;
h(1)=-.010597;

g(7)=-h(8);
g(8)=h(7);
g(9)=-h(6);
g(10)=h(5);
g(11)=-h(4);
g(12)=h(3);
g(13)=-h(2);
g(14)=h(1);

w=h'*h;
w1=g'*g;
w2=h'*g;
w3=g'*h;
C=conv2(A,w);
dobl=conv2(A,w1);
dvert=conv2(A,w2);
dhor=conv2(A,w3);

B=C(7:N+7,7:N+7);
B1=dobl(7:N+7,7:N+7);
B2=dvert(7:N+7,7:N+7);
B3=dhor(7:N+7,7:N+7);

for k=1:m,
  for l=1:m,
    R(k,l)=B(2*k-1,2*l-1);
    Dobl(k,l)=B1(2*k-1,2*l-1);
    Dvert(k,l)=B2(2*k-1,2*l-1);
    Dhor(k,l)=B3(2*k-1,2*l-1);
  end  
end
a=fix(m/20);
R1=[R; zeros(a,m)];
R1=[R1 zeros(a+m,a)];
Dvert1=[Dvert;zeros(a,m)];
Dvert1=[zeros(a+m,a) Dvert1];
Dhor1=[zeros(a,m);Dhor];
Dhor1=[Dhor1 zeros(a+m,a)];
Dobl1=[zeros(a,m) ;Dobl];
Dobl1=[zeros(a+m,a) Dobl1];
decomp=[R1 Dvert1; Dhor1 Dobl1];
