function f=forme(R,tau,a,b,c,d,alpha,beta,epsilon);

%          f=forme(R,tau,a,b,c,d,alpha,beta,epsilon); 
%Programme generant des fonctions caracteristiques d'ensembles limites par des 
%coniques; dans (-R:tau:R-tau,-R:tau:R-tau), on represente la fonction caracteristique 
%du domaine Q<epsilon ou 
%             Q(x,y)=x^2/a^2+ y^2/b^2 -c*(x*y) -2*alpha*x-2*beta*y -d 
%Ce programme fournit des images-test pour les programmes RADON, RETROPROJ, INVRADONITEREE
%illustrant la transformation de Radon 2D et son inversion. 


x=-R:tau:R-tau;
x=x';
L=zeros(length(x));
A=ones(1,length(x));
XX=x*A;
XXX=XX.^2;
YY=A'*x';
YYY=YY.^2;
XY=x*x';
Q=XXX/a^2 + YYY/b^2-c*XY-2*alpha*XX- 2*beta*YY-d*ones(length(x));
[I,J]=find(Q<epsilon);
m=length(I);
for k=1:m 
   L(I(k),J(k))=1;
end
f=L;
   
