function [h,w] = freqz_aux(b,a,n,dum)

%Programme auxiliaire utilise dans autoreg2

a = a(:).';
b = b(:).';
na = max(size(a));
nb = max(size(b));
nn = max(size(n));
s = 2;
if nargin == 4
	s = 1;
end
if nn == 1
	w = (2*pi/s*(0:n-1)/n)';
else
	w = n;
	n = nn;
end
if (nn == 1)
	if s*n < na | s*n < nb
		nfft = lcm(n,max(na,nb));
		h = (fft([b zeros(1,s*nfft-nb)]) ./ fft([a zeros(1,s*nfft-na)])).';
		h = h(1+(0:n-1)*nfft/n);
	else
		h = (fft([b zeros(1,s*n-nb)]) ./ fft([a zeros(1,s*n-na)])).';
		h = h(1:n);
	end
else
%	Frequency vector specified.  Use Horner's method of polynomial
%	evaluation at the frequency points and divide the numerator
%	by the denominator.
	a = [a zeros(1,nb-na)];  % Make sure a and b have the same length
	b = [b zeros(1,na-nb)];
	s = exp(sqrt(-1)*w);
	h = polyval(b,s) ./ polyval(a,s);
end
