function [A,L]= gauss3q(s,j,n_voix,q)

%     [A,L]=gauss3q(x,j,n_voix,q); 
% Calcule les divers niveaux dyadiques de 
% l'image temps-echelles avec comme ondelette 
% la derivee a l'ordre q de l'atome de Gauss et 
% reconstitue une coupe L de l'image a l'echelle 
% 2^(j+1) a partir du comportement de l'image 
% entre les echelles 2^(j-1) et 2^j (decoupee 
% en n_voix canaux). La valeur 
%j=log_2 (length(s))-1 correspond a l'echelle la plus 
%fine, j=2 a l'echelle la plus grossiere.   


 
    
N=length(s);
[A1,A2,A3]=gaussq(s,1,q);
A1=A1';
x1=A1(j,:);
B2=gauss2q(s,j-1,n_voix,q);
A=zeros(1,n_voix);
t0=0:n_voix-1;
t=-t0/n_voix;
x2=zeros(1,N);
for k=1:N 
   if x1(k)==0 
      x2(k)=0;
   else
     A=B2(:,k)';
     C=polyfit(t,A,1); 
     c=C(1);
     x2(k)=2^(c*log(2))*x1(k);
   end
end
A=A1;
L=x2;



 