function [A1, A2, A3]= gaussq(s,n_voix,q)

%     [A1,A2,A3]=gaussq(x,n_voix,q)
%Cette fonction restaure les maxima locaux de 
%la transformee en ondelettes continue 
%correspondant a l'atome g^(q), derivee a 
%l'ordre q de l'atome Gaussien. 
%A1 donne les maxima locaux avec leur signe
%A2 donne les maxima locaux en valeur absolue
%A3 donne l'image de la transformation WT. 
%n_voix est le nombre de voix par octave. 
%L'indice de ligne est le temps. 
%L'indice de colonne est l'echelle. 

 
    

nn    = length(s);
shat = fft(s);
r=mod(q,2);
xi   = [ (0: (nn/2)) (((-nn/2)+1):-1) ] .* (2*pi); 
n_octaves=floor(log2(nn))-1; 	
n_echelles=n_voix.* n_octaves;
k_echelle=1;
echelle=4;
B1= zeros(nn,n_echelles);
B2= zeros(nn,n_echelles);
B3=zeros(nn,n_echelles);
for j = 1:n_octaves,
	    for l = 0:n_voix-1,
		   q_echelle = echelle.* (2^(l/n_voix));
		   omega  = xi ./ q_echelle ;
                   psi_hat=(omega.^q).* exp(-(omega.^2) ./2);
		   w_hat = psi_hat .* shat;
		   w    = ifft(w_hat);
                   if (r==0) 
                      u1=locmax(real(w));
                      u3=real(w);
                   else
                      u1=locmax(imag(w));
                      u3=imag(w);
                   end
                      u2=localmax(abs(w));	
                   B1(1:nn,k_echelle)=u1';
                   B2(1:nn,k_echelle)=u2';
                   B3(1:nn,k_echelle)=u3';
		   k_echelle = k_echelle+1;
	    end
	    echelle  = echelle *2;
    	end 
 B2(nn,:)=zeros(1,n_echelles);
 A1=B1;
 A2=B2;
 A3=B3;
		    
 