function f=genfl(s,type,a,b);

%        f=genfl(s,type,a,b);
% Transformation de Flandrin generalisee. 
% Calcule l'une des deux transformations (type 'sp' pour 
% ''spectrogramme'' ou ''ww'' pour Wigner-Ville fenetree) 
% du signal s. 
% Si type='sp', la fenetre est une fenetre de 
% hamming de longueur a=32, 64, 128. 
% Si 'type'='ww', a=32, 64, 128 et b sont les longueurs des 
% fenetres  h et g frequentielle et temporelle (voir WWIG).  
% L'image est extrapolee en frequence a partir de fenetres
% de taille (a,128) et traitee localement par re-assignement. 

N=length(s);
l=1;
r=128;
d=128;
i=0;
if (strcmp(type,'ww'))
  u=128+2*a+b; 
else u=128+a; 
end;

while u<N
  i=i+1;
  clc
  disp(l)
  if (strcmp(type,'ww'))
    mr=128/a;
    m=wwig(hamming(a),hamming(b),s(l:u));
    m=abs(m);
 else
    mr=fix(256/a);
    m=wfft(hamming(a)',s(l:u));
  end;
  m=interp2D(m,mr,1); 
  
  flt=flandrin(hamming(4)*hamming(4)',m);
  if (i==1)
    f=flt;
  else
   f=[f zeros(r,d-1)]+[zeros(r,(i-1)*(d-1)) flt];
  end;

  l=l+d;
  u=u+d;
end;











