function y = hilbert(x)

% y=hilbert(x)
% Calcule la transformee de Hilbert de la 
% partie reelle d'un signal. Si x est une matrice, 
% la sortie est la matrice dont les colonnes sont 
% les transformees de Hilbert des colonnes de x. 

[r,c] = size(x);
if r == 1
	x = x.';   
end;
[n,cc] = size(x);
m = 2^nextpow2(n);
y = fft(real(x),m);
if m ~= 1
	h = [1; 2*ones(fix((m-1)/2),1); 1; zeros(fix((m-1)/2),1)];
	y(:) = y.*h(:, ones(1,cc) );
end
y = ifft(y,m);
y = y(1:n,:);
if r == 1
	y = y.';
end

