function s=icwtg(A,q); 

%A=icwtg(A,q); 
%Cette fonction inverse la transformee en ondelettes 
%continue (l'ondelette etant la derivee d'ordre q d'une 
%gaussienne); la matrice d'entree A est une matrice a 
%(p-1)*m lignes et 2^n colonnes, correspondant a la 
%transformee en ondelette continue d'un signal s 
%de longueur 2^p, le nombre de voix etant m, ou 
%a une modification de cette matrice (via par 
%exemple les algorithmes gaussq, gaussq3 ou les algorithmes 
%consistant a interpoler sur chaque colonne les 
%maxima locaux). Cette operation d'inversion 
%ne fonctionne numeriquement que sur les signaux 
%de moyenne nulle (la formule d'inversion de la 
%transformee en ondelettes continue n'est valide 
%que sur l'espace des signaux d'energie finie).  

[nn,mm]=size(A);
s=zeros(1,nn);
n_octaves=floor(log2(nn))-1;
n_voix=fix(mm/n_octaves); 
cwt_hat = fft(A);
r=mod(q,2);
xi   = [ (0: (nn/2)) (((-nn/2)+1):-1) ] .* (2*pi); 
	
n_echelles=mm;
k_echelle=1;
echelle=4;
B= zeros(nn,n_echelles);

for j = 1:n_octaves,
	    for l = 0:n_voix-1,
	           t=n_voix*(j-1)+l+1;
		   q_echelle = echelle.* (2^(l/n_voix));
		   omega  = (xi ./ q_echelle)' ;
                   psi_hat=(omega.^q).* exp(-(omega.^2) ./2);
		   w_hat = psi_hat .* (cwt_hat(:,t)); 
		   w    = ifft(w_hat);
                   if (r==0) 

                      u=real(w);
                   else

                      u=-imag(w);
                   end
                B(1:nn,k_echelle)=u;
		   k_echelle = k_echelle+1;
	    end
	    echelle  = echelle *2;
    	end 
s=sum(conj(B'));
s=2*s/gamma(q);
s=log(2)*s/n_voix;
     	
 
		    
 