function imagecwt(cwt, normalisation , couleur)

% imagecwt(cwt,normalisation,couleur)
%Affiche l'image de la transformee en ondelettes 
%continue (cwt). Si le troisieme argument (couleur) 
%n'est pas precise, colors='hot'
%Pour l'argument normalisation, on peut utiliser 
%soit 'globale', soit 'locale'.


if nargin < 3,
  couleur='hot';
end	
n_niveaux = 256;		
sz     = size(cwt);
n = sz(1); 
n_echelles= sz(2);
n_octaves = floor(log2(n))-1;
n_voix  = n_echelles ./ n_octaves;
ytix   = linspace(2,(n_octaves+2),n_echelles); 
xtix   = linspace(0,1,n);
		
	
if strcmp(normalisation,'locale'),
	for k=1:n_echelles,
	  goodstart = max(1, min(n/2 .* 2^(-k/n_voix), n/4));
	  amax  = max(abs(cwt(goodstart:(n-goodstart),k)));
	  cwt(:,k) = abs(cwt(:,k)) ./ amax .*n_niveaux;
	end
elseif strcmp(normalisation,'globale'),
	amax = 0;
	for k=1:n_echelles,
      goodstart = max(1, min(n/2 .* 2^(-k/n_voix), n/4));
      goodstart=fix(goodstart);
      amax      = max(amax,max(abs(cwt(goodstart:(n-goodstart),k))));
	end
	    cwt = abs(cwt) ./ amax .*n_niveaux;
	else
	    error('Usage imagecwt normalisation = locale| globale');
	end


	image(xtix,ytix, cwt');
	axis('ij');
	xlabel('Intervalle temporel normalise entre t=0 et t=1')
	ylabel('log2(1/a)')
	
	str = sprintf('colormap(%s(%s))',couleur,int2str(n_niveaux));
	eval(str)
			
	 
    
    
