function B=interpol1(A);

%        function B=interpol1(A);
%Si A est une matrice colonne donnee par un vecteur v, 
%prenant la valeur 0 sur un sous-ensemble E, cette fonction  
%interpole v par le vecteur obtenu en interpolant 
%aux points de E les valeurs prises sur le complementaire 
%de cet ensemble. On peut l'utiliser en particulier pour remplacer 
%un vecteur par le vecteur obtenu en interpolant les maxima locaux. 
%Si A est une matrice, l'operation est effectuee sur toutes les 
%colonnes de la matrice. 

mm=size(A);
B=zeros(mm);
for l=1:mm(2)
   v=A(:,l);
   x=find(~v==0);
   lv=length(v);
   lx=length(x);
   t=zeros(lv,1);
   for kx=1:lx-1
      vc=v(x(kx));
      vp=v(x(kx+1));
      delta_x=x(kx+1)-x(kx);
      t(x(kx):x(kx+1))=retta(vc,vp,delta_x+1);
   end;
   B(:,l)=t;
end   

