function B=interpol2(A,ir,ic);

%   B=interpol2(A,ir,ic);
% B=interpol2(A,ir,ic) transforme une matrice 
% A de taille (m,n) en la matrice B de taille 
% (m*ir,m*ic) obtenue par interpolation. 

M=size(A,2);
nw=[];
nnw=nw;
if (ir>1)
  for k=1:M
    c=A(:,k);
    nc=interp(c,ir);
    nw=[nw nc];
  end;
else nw=A;
end;

N=size(nw,1);
if (ic>1)
  for k=1:N
    r=nw(k,:);
    nr=interp(r,ic);
    nnw=[nnw;nr];
  end;
else nnw=nw;
end;
B=nnw;


