function f=invradoniteree(m,R,tau,A,B,iter);

%              f=invradoniteree(m,R,tau,A,B,iter);
%Inversion de la transformation de radon 2D suivant le 
%schema des projections iterees (cf livre, page 189). Ici B est le sinogramme 
%(c'est-a-dire la transformee de Radon) d'une image  
%               Ainit(-R:tau:R-tau,-R:tau:R-tau) 
%tronquee au disque D(0,R); ce sinogramme peut etre eventuellement bruite.   
%Les angles correspondant aux projections successives xi sont pris de 0 a 2*pi avec 
%un pas de m*(2*pi/M), ou M designe le nombre de lignes de B (2*pi/M etant donc  
%la resolution angulaire du sinogramme). L'algorithme est itere iter fois. 
%la matrice A est la matrice choisie pour initier l'algorithme 
%(en principe A=zeros(-R:tau:R-tau,-R:tau:R-tau)). 
%Le mecanisme affiche un compteur d'iterations (ll).  


x=-R:tau:R-tau;
p=-R:tau:R-tau; 
[M,MM]=size(B); 
pp=2*sqrt(R^2-p.^2);
pp(1)=pp(2); 
a=ones(1,MM);
S=zeros(1,MM);
AA=zeros(MM,MM);
x=x';
XX=x*a;
YY=a'*x';
ll=0; 
for i=1:iter 
   for q=1:m:M
      Q=cos((q-1)*(2*pi)/M)*XX+sin((q-1)*(2*pi)/M)*YY+R*ones(MM);
      Q1=max(Q/tau,zeros(MM));
      Q1=min(Q1,(MM-1)*ones(MM));
      Q1=round(Q1+ones(MM));
      for j=1:MM
         QQ=Q-(j-1)*tau*ones(MM);
         [I,J]=find(abs(QQ)<tau/2);
         S(j)=tau*sum(diag (A(I,J)));
      end
      for k=1:MM
         for l=1:MM
            AA(k,l)=(B(q,Q1(k,l))-S(Q1(k,l)))/pp(Q1(k,l));
         end
      end
      A=A+disque(R,tau).*AA;
   end
   ll=ll+1;
   ll
end
f=A;

      

