function f=irrdaub4(x);

% f=irrdaub4(x);
%Action of the operator R^* associated with the Daubechies 
%multiresolution analysis with 4 parameters. 

N=length(x);
h=zeros(1,6);

h(3)=.48296;
h(4)=.83652;
h(5)=.22414;
h(6)=-.12941;


h1=[h(1) h(3) h(5)];
h2=[h(2) h(4) h(6)];

c1=conv(x,h1);
c2=conv(x,h2);

l=N+2;
ll=2*(N+2);
f=zeros(1,l);

for k=1:l
      f(2*k-1)=c1(k);
end;
   
for k=1:l
  f(2*k)=c2(k);
end;







