function f=irrdaub8(x);

% f=irrdaub8(x);
%Action of the operator R^* associated with the Daubechies 
%multiresolution analysis with 8 parameters. 

N=length(x);
h=zeros(1,14);
h(7)=.230378;
h(8)=.714846;
h(9)=.630881;
h(10)=-.027984;
h(11)=-.187035;
h(12)=.030841;
h(13)=.032883;
h(14)=-.010597;

h1=[h(1) h(3) h(5) h(7) h(9) h(11) h(13)];
h2=[h(2) h(4) h(6) h(8) h(10) h(12) h(14)];

c1=conv(x,h1);
c2=conv(x,h2);

l=N+6;
ll=2*(N+6);
f=zeros(1,l);

for k=1:l
      f(2*k-1)=c1(k);
end;
   
for k=1:l
  f(2*k)=c2(k);
end;







