function X=localmax(Z,tot)

%X=localmax(Z,tot)  
%donne les premiers maxima locaux du module 
%du vecteur ligne Z (si les maxima sont dans l'ordre 
%decroissant) en respectant leur position.  
%X=localmax(Z)  donne tous les maxima locaux du module du  
%vecteur ligne Z en respectant leur position. 


if nargin<1 | nargin>2
	error('Usage: X=localmax(Z,[tot])');
elseif nargin==1,
	tot=length(Z);
end

if min(size(Z))>1;
	error('Usage: X=localmax(Z,[tot]), Z doit etre un vecteur!');
end

Z=Z(:)';
X=zeros(2,length(Z));
MAXX=length(Z);MINN=1;stop=1;

pos=zeros(2,length(Z));
A=find(Z>0);pos(1,A)=Z(A);
A=find(Z<0);
if isempty(A)==1
   pos(2,:)=zeros(1,length(Z));
else
   pos(2,A)=-Z(A);
end
clear A Z


for f=1:2
  z=pos(f,:);
  while any(z) & stop<=tot;
   
   maxz=find(z==max(z));
   X(f,maxz)=z(maxz);
   old1=z(min(maxz));			
   z(maxz)=zeros(size(maxz));   
   MAXD=1;

   for  k=1:length(maxz)
	flagdestro=1;flagsinistro=1;
	sinistro=maxz(k)-1;
	old=old1;
	
	while flagsinistro
	   if sinistro>=MINN & sinistro>=MAXD;
	      if z(sinistro)<=old & z(sinistro)>0
		old=z(sinistro);
		z(sinistro)=0;
		sinistro=sinistro-1;
	      else
		flagsinistro=0;
	      end
	   else
	      flagsinistro=0;
	   end
	end
	
	old=old1;
	destro=maxz(k)+1;
	
	while flagdestro
	   if destro<=MAXX & destro>=MAXD     
	      if z(destro)<=old & z(destro)>0
		old=z(destro);
		z(destro)=0;
		destro=destro+1;
	      else
		flagdestro=0;
		MAXD=destro;
	      end
	   else
	      flagdestro=0;
	   end
	end
	
   end%for
   stop=stop+1;
 end%while
end%for

X=X(1,:)-X(2,:);





