function [D,r,sp]=merge(s,q,m);

% [D,r,sp]=merge(s,q,m); 
%Calcule une etape de l'algorithme MERGE. 
%Le niveau d'echelle est q; D est la matrice 
%dont les lignes sont les atomes de details. 
%r est le resume. L'algorithme peut etre itere en 
%[D1,r1,sp1]=merge(s,1,m);
%[D2,r2,sp2]=merge(r1,2,m); 
%[D3,r3,sp3]=merge(r2,3,m); 
%....
%autant de fois qu'on le souhaite. 
%On genere ainsi la sequence MERGE. 
%2^m est la marge de recouvrement des fenetres 
%La ligne sp(i,:) represente le spectre du signal 
%D(i,:) sur l'intervalle [0,pi/tau], ou tau est 
%le pas d'echantillonnage. 

N=length(s);
D=[];
sp=[];
L=2^(q+m);
LW1=(2^q+1)*2^m;
LW2=(2^(q+1)+1)*2^m;
p=0;
d=zeros(1,N);
r=zeros(1,N);
while (p+1)*L+LW1<=N,
   s1=s(p*L+1:p*L+LW1);
   s2=s((p+1)*L+1:(p+1)*L+LW1);
   s0=s(p*L+1:p*L+LW2);
   ss1=abs(s1);
   ss2=abs(s2);
   a1=max(ss1(2^m+1:1:LW1-2^m));
   a2=max(ss2(2^m+1:1:LW1-2^m));
   [e1,ws1,sp1]=malvar_aux(s1,q,m);
 if a1>10^(-6)
   
   if a2<10^(-6)
      dd1=[zeros(1,p*L) ws1 zeros(1,N-p*L-LW1)];
      D=[D;dd1];
      sp=[sp;sp1]; 
   else
        [e2,ws2,sp2]=malvar_aux(s2,q,m);
        [e0,ws0,sp0]=malvar_aux(s0,q+1,m);
     if e1+e2<e0
        dd1=[zeros(1,p*L) ws1 zeros(1,N-p*L-LW1)];
        dd2=[zeros(1,(p+1)*L) ws2 zeros(1,N-(p+1)*L-LW1)];
        D=[D;dd1;dd2];
        sp=[sp;sp1;sp2];
     else
        r=r+[zeros(1,p*L) ws0 zeros(1,N-p*L-LW2)];
     end;
  end;
  
else
   if a2>10^(-6);
      
   [e2,ws2,sp2]=malvar_aux(s2,q,m);
   dd2=[zeros(1,(p+1)*L) ws2 zeros(1,N-(p+1)*L-LW1)];
   D=[D;dd2];
   sp=[sp;sp2];
   end
 end
 p=p+2;
end;
