function d=merge1(s,m);

%  d=merge1(s,m); 
%Decomposition d'un signal s suivant l'algorithme 
% ''MERGE'' relatif a l'accordeon de Malvar. 2^m 
%represente la largeur de la bande temporelle de 
%recouvrement des fenetres d'exploration. La sortie d 
%donne les composantes de la decomposition regroupees 
%par niveau d'echelle, les echelles etant ordonnees 
%dans l'ordre croissant. Si tous les details sont nuls, 
%le signal est a laisser tel quel. 

N=length(s);
q=1;
d=[];

while (2^q+1)*2^m <=N 
   
L=2^(q+m);
LW1=(2^q+1)*2^m;
LW2=(2^(q+1)+1)*2^m;
p=0;
r=zeros(1,N);
dd=zeros(1,N);
while (p+1)*L+LW1<=N,
   a=p*L+1;
   s1=s(p*L+1:p*L+LW1);
   s2=s((p+1)*L+1:(p+1)*L+LW1);
   ss1=abs(s1);
   ss2=abs(s2);
   a1=max(ss1(2^m+1:LW1-2^m));
   a2=max(ss2(2^m+1:LW1-2^m));
   s0=s(p*L+1:p*L+LW2);
   [e1,ws1,sp1]=malvar_aux(s1,q,m);
   
 if a1>10^(-6)  
  if a2<10^(-6)
      dd1=[zeros(1,p*L) ws1 zeros(1,N-p*L-LW1)];
      dd=dd+dd1; 
  else
   [e2,ws2,sp2]=malvar_aux(s2,q,m);
   [e0,ws0,sp0]=malvar_aux(s0,q+1,m);
   if e1+e2<e0
      dd1=[zeros(1,p*L) ws1 zeros(1,N-p*L-LW1)];
      dd2=[zeros(1,(p+1)*L) ws2 zeros(1,N-(p+1)*L-LW1)];
      dd=dd+dd1+dd2;
   else
      r=r+[zeros(1,p*L) ws0 zeros(1,N-p*L-LW2)];
   end;
  end;
 else 
   if a2>10^(-6);
      
   [e2,ws2,sp2]=malvar_aux(s2,q,m);
   dd2=[zeros(1,(p+1)*L) ws2 zeros(1,N-(p+1)*L-LW1)];
   dd=dd+dd2;
   end
 end;
   p=p+2;
end;
[d]=[d;dd];
s=r;
q=q+1;

end;
