function [f,R1,R2,err]=mpurs1(D,s,epsilon,k);

% [f,R1,R2,err]=mpurs1(D,s,epsilon,k);
% effectue le matching-pursuit ordinaire d'un signal s 
% de taille (1,N) suivant un dictionnaire D
% dont les atomes sont les D(j,:), j=1,..., m
% Le dictionnaire D est de une matrice de taille (m,N).
% l'algorithme s'arrete apres k iterations ou 
% des que l'energie E(r) du reste 
% est telle que E(r) < epsilon E(s), ou E(s)
% designe l'energie du signal.
% La sortie f est une matrice de taille (m,N) dont les lignes 
% successives, f(:,j), j=1,2,..., sont les approximations 
% successives de s. La commande plot(R1) (resp. plot(R2)) donne les 
% numeros des atomes choisis (en abscisses) et les 
% parties reelles (resp. imaginaires) des coefficients dont ils sont 
% affectes (en ordonnees) lorsque les atomes sont normalises 
% et d'energie egale a 1. La variable err designe l'erreur relative
% commise apres $k$ iterations en termes  d'energie. 

[m,N]=size(D);
f=[];
resume=zeros(1,N);
E=s*s';
err=1;
err0=epsilon;
R1=zeros(1,m);
R2=zeros(1,m);
for i=1:k
   if err0<err
      M=D*s';
      M1=abs(M);
      pmx=max1(M1);
      a=M(pmx);
      ed=D(pmx,:)*D(pmx,:)';
      R1(pmx)=R1(pmx)+ (real(M(pmx))/sqrt(ed));
      R2(pmx)=R2(pmx)+ (imag(M(pmx))/sqrt(ed));
      resume=resume+(a/ed)*D(pmx,:);
      s=s-(a/ed)*D(pmx,:);
      err=s*s'/E;
      f=[f;resume];    
   end  
end
   


