function [f,R1,R2,err]=mpurs2(D,s,epsilon,k);

% [f,R1,R2,err]=mpurs2(D,s,epsilon,k);
% effectue le matching-pursuit orthogonal d'un signal s 
% de taille (1,N) suivant un dictionnaire D
% dont les atomes sont les D(j,:), j=1,..., m
% D est de une matrice de taille (m,N)
% l'algorithme s'arrete au bout de k operations 
% ou des que l'energie E(r) 
% du reste est telle que E(r) < epsilon E(s), ou E(s)
% designe l'energie du signal. 
% La commande plot(R1) (resp plot(R2) 
% donne (en abscisses) les numeros des 
% atomes retenus et (en ordonnees) la valeur 
% de la partie reelle (resp. imaginaire) du coefficient trouve 
% dans le resume au cran k de l'algorithme. 
% Les atomes sont supposes normalises, d'energie 1.   
% err designe l'erreur d'energie relative.  
% f est une matrice de taille (m,N) dont les lignes 
% successives, f(:,j), j=1,2,..., sont les approximations 
% successives de s. 

[m,N]=size(D);
R1=zeros(1,m);
R2=zeros(1,m);
r=zeros(1,N);
E=s*s';
err=1;
err0=epsilon;
M=D*s';
M1=abs(M);
pmx=max1(M1);
a=M(pmx);
epmx=D(pmx,:)*D(pmx,:)';
newatom=D(pmx,:)/sqrt(epmx);
resume=(a/sqrt(epmx))*newatom;
coeff=[a/sqrt(epmx)];
natom=[pmx];
atoms=[newatom];
f=[resume];
invgram=[1];
D(pmx,:)=zeros(1,N);
for i=2:k
   if err0<err     
      reste=s-resume;
      M=D*reste';
      MM=abs(M);
      pmx=max1(MM);
      a=M(pmx);
      epmx=D(pmx,:)*D(pmx,:)';
      newatom=D(pmx,:)/sqrt(epmx);
      CC=newatom*atoms';
      C=conj(CC)';
      B=invgram*C;
      BB=conj(B');
      ed=1-(BB*CC');
      newcoeff=ed^(-1)*(reste*newatom');
      a1=coeff-newcoeff*BB;
      coeff=[a1,newcoeff];
      atoms=[atoms; newatom];
      resume=coeff*atoms;
      natom=[natom,pmx];
      D(pmx,:)=zeros(1,N);
      reste=s-resume;
      err=reste*reste'/E;
      f=[f;resume];
      beta=(1-conj(CC)*B)^(-1);
      invgram=[invgram + beta*B*B', -beta*B; -beta*B', beta]; 
   end  
end
k1=length(natom);
for j=1:k1, 
   l=fix(natom(j));
   R1(l)=real(coeff(j));
   R2(l)=imag (coeff(j));
end   

