function f=music1h(g,h,m1,m2,s);

% f=music1h(g,h,m1,m2,s);
% Calcule le m1-estimateur frequentiel MUSIC 
% attache a une correlation glissante du signal s
% a fenetres g,h, length(h) superieure ou egale a m1 et a length(g). 
% le parametre m2 est le pas d'echantillonnage temporel 
% le signal est duplique dans la fenetre glissante. 
% Le signal s et les fenetres g,h, sont des vecteurs lignes. 
% Le signal est remplace par la transformee de Hilbert de 
% sa partie reelle dans chaque fenetre. 

M=length(s);
N=length(h);
n=length(g);
H=h'*h;
g=[g,zeros(1,N-n)];
r=fix((M-N)/m2)+1;
music=zeros(N,r);
c=zeros(N,N);
ax1=zeros(N,N);
ax2=zeros(N,N);

for j=0:r-1;
    s1=s((1+m2*j):(1+m2*j+N-1));
    s1=hilbert(s1);
    s2=[s1,s1];
  for l=0:(N-1) 
    for k=1:N
      ax1(k,l+1)=(1/N)*(s2(l+1+N-k));
      ax2(k,l+1)=(1/N)*g(l+1)*(s2(l+1+N-k));
    end
  end
    c=ax2*ax1';
    c=H.*c;
    c=N*c;
    [U,D,V]=svd(c);
    vprinc=U(:,1:m1);
    f=vprinc;
    W=fft(vprinc);
    W1=(1/N)*abs(W).^2;
    S=sum(W1');
    f=S;
  for i=1:N
    music(i,j+1)=1/(1-S(i))-1;
   end
end 
    N1=fix(N/2);
    music1=music(1:N1,:);
    music2=music(N1+1:N,:);
    music=[music2; music1];
 f=music;