function f=nfrankl(n,l,x);

%       f=nfrankl(n,l,x);
% Choix possibles de n: 2, 3, 5
% Calcule la projection orthogonale d'un 
% signal ligne de longueur N=2^(q1)*3^(q2)*5^(q3)+1
% affine par morceaux avec noeuds 
% - aux points 2^l* 3^(q2)*5^(q3) si n=2
% - ,,   ,,    2^(q1)*3^l *5^(q3) si n=3
% - ,,   ,,    2^(q1)*3^(q2)*5^l  si n=5
% sur le sous espace des signaux de longueur N 
% affines par morceaux avec noeuds 
% - aux points 2^(l+1)* 3^(q2)*5^(q3) si n=2
% - ,,   ,,    2^(q1)*3^(l+1) *5^(q3) si n=3
% - ,,   ,,    2^(q1)*3^(q2)*5^(l+1)  si n=5
% L'algorithme peut etre itere comme ci dessous
% r1=nfrankl(n,0,x);
% d1=x-r1;
% r2=nfrankl(n,0,r1);
% d2=r1-r2;
% r3=nfrankl(n,1,r2);
%...
% afin d'obtenir resumes et details dans la decomposition 
% de Franklin de pas 2, 3 ou 5, ainsi que des decompositions 
% non-orthogonales mixant ces 3 decompositions de Franklin. 

z=decomp(length(x));
m=z(1);
k=z(2);
h=z(3);
if ~(((m==0) & (n==2)) | ((k==0) & (n==3)) | ((h==0) & (n==5)))
  s=ones(1,(2^m*3^k*5^h)/(n^l)+1);
  y=size(s);
  for i=1:y(2)
    s(i)=x(1+(i-1)*n^l);
  end
  if n==2
    C=nfrankx(m-l-1,k,h,n);
  elseif n==3
    C=nfrankx(m,k-l-1,h,n);
  elseif n==5
    C=nfrankx(m,k,h-l-1,n); 
  end;
  g1=ngram(m,k,h,l,n);
  C2=g1*C';
  y1=s*C2;
  y=y1';
  g=ngram(m,k,h,l+1,n);
  u=inv(g)*y;
  t=u';
  s1=t*C;
  w=s1';
  if n==2
    for p=(m-l):(m-1),
       w=(nfrankx(p,k,h,n)')*w;
    end
  elseif n==3
    for p=(k-l):(k-1),
       w=(nfrankx(m,p,h,n)')*w;
    end
  elseif n==5
    for p=(h-l):(h-1),
       w=(nfrankx(m,k,p,n)')*w;
    end
  end;
  f=w';
else
  'Decomposition impossible '
end