function f=papoulis(s,T0,T,tau,Omega,k);
% f=papoulis(s,T0,T,tau,Omega,k); 
% Etant donne un signal s sur -T0:tau:T0-tau 
% de spectre inclus dans [-Omega,Omega],
% et un reel T entre O et T0, l'algorithme 
%
calcule l'extrapolation  apres k iterations 
% du signal s depuis l'intervalle [-T,T] jusqu'a 
% l'intervalle [-T0,T0]. L'extrapolation n'est fiable 
% que sur un intervalle [-T0-epsilon,T0+epsilon]
% avec epsilon petit. 

t=-T:tau:T;
omega=-Omega:pi/T0:Omega;
N=fix(length (s)/2);
a1=fix(length(t)/2);
a2=fix (length(omega)/2);
wtemps=[zeros(1,N-a1), ones(1,2*a1), zeros(1,N-a1)];
wfreq=[zeros(1,N-a2), ones(1,2*a2), zeros(1,N-a2)];
g=wtemps.*s;
for l=1:k; 
  G=spectre(g,T0);
  F=wfreq.*G;
  f=ispectr(F,N*(pi/T0));
  g=f+(s-f).*wtemps;
end  
  f=g;





