function f=plfr(q,s);

% plfr(q,s)
% ce programme permet de visualiser, etant donne un signal s, 
% de taille (1,2^q+1), avec q>6, le signal s et 6 niveaux de details D1,...,D6, 
% de la decomposition orthogonale de s sur les espaces de fonctions 
% affines par morceaux avec noeuds aux points 2l+1,4l+1,....
% ce programme affiche aussi le graphe du resume R6 et par consequent 
% la decomposition orthogonale complete s=D1+...+D6+R6

 
i=1:(2^q+1);
y=s-mean(s);
m0=max(abs(y));
r1=franklin(0,q,y);
d1=y-r1;
m1=max(abs(d1));
r2=franklin(1,q,r1);
d2=r1-r2;
m2=max(abs(d2));
r3=franklin(2,q,r2);
d3=r2-r3;
m3=max(abs(d3));
r4=franklin(3,q,r3);
d4=r3-r4;
m4=max(abs(d4));
r5=franklin(4,q,r4);
d5=r4-r5;
m5=max(abs(d5));
r6=franklin(5,q,r5);
d6=r5-r6;
m6=max(abs(d6));
m7=max(abs(r6));
M2=m1+m2+1;
M3=M2+m2+m3+1;
M4=M3+m3+m4+1;
M5=M4+m4+m5+1;
M6=M5+m5+m6+1;
M7=M6+m6+m7+1;
M8=M7+m7+1;
plot(i,y-m0-m1,i,d1,'r-', i,d2+M2, 'b-', i,d3+M3, 'g-', i, d4+M4, 'y-', i, d5+M5, 'c-', i,d6+M6,'m-', i, r6+M7);
N=2^q+1;
axis([1 N -m0-m1-m0-1 M8])
gy=get(gca,'Ylim');
ly=gy(1);
hy=gy(2);
v=['s' ' ' ' ' ' ';
   'd' '1' ' ' ' ';
   'd' '2' ' ' ' ';
   'd' '3' ' ' ' ';
   'd' '4' ' ' ' ';
   'd' '5' ' ' ' ';
   'd' '6' ' ' ' ';
   'r' '6' ' ' ' '];
vet=[-m0-m1 0 M2 M3 M4 M5 M6 M7];
set(gca,'Ylim',[ly hy],'YTick',vet,'YTickLabels',v);
set(gca,'XColor','w');