function C=polar(x,y,z,m,p,epsilon)

% C=polar(x,y,z,m,p,epsilon)
%
% Calcule la fonction de polarisation associee a la  donnee de trois observations (en ligne), 
% x,y,z (objet: detection de l'instant d'arrivee-- ou des instants d'arrivee successifs-- de l'onde (P) 
% dans un signal  correspondant a l'enregistrement d'une secousse sismique). 
% Le programme calcule la matrice d'inter-correlation glissante
% dans une fenetre de longueur m deplacee avec un pas 1. 
% Les parametres epsilon et p<m designent des seuils de 
% tolerance, a savoir que l'on a a l'instant i :  
%   -- si (x,y,z) sont de module <epsilon  sur [i-p,i+p], c(i)=0 :
%   -- si (x,y,z) sont de module <epsilon  sur [i,i+p], c(i) est calcule a partir du passe des entrees ;
%   -- si (x,y,z) sont de module <epsilon  sur [i-p,i], c(i) est calcule a partir de futur des entrees .  
% Le programme calcule ensuite la difference (glissante) 
%        1-lambda_2/lambda_1
% ou lambda_1>=lambda_2 sont les deux premieres valeurs propres 
% de la matrice d'inter-correlation. 
% Ce programme est concu pour etre utilise lorsque (x,y,z) correspondent a des lignes 
% (de meme etiquette, ou combinees de maniere a correspondre a des composantes de meme etiquette, 
% voir le help de wpack4 ou wpack8) extraites respectivement des matrices (U_x,U_y,U_z) obtenues a partir de:
%
%  [U_x,etiq_x]=wpack8 (s_EW,m), [U_y,etiq_y]=wpack8(s_NS,m), [U_z,etiq_z]=wpack8(s_VERT,m)
% 
% ou (s_EW,s_NS,s_VERT) representent les 3 composantes d'un signal sismique s 
% enregistrees respectivement dans les directions Est-Ouest, Nord-Sud, ou Verticale (on peut 
% aussi remplacer wpack8 par wpack4). 

M=length(x);
M1=M-m;
u=0; 
Y=[];
C=zeros(1,M1-m);
for i=m+1:M1,
   x_fen=x(i-m:i+m-1)';
   y_fen=y(i-m:i+m-1)';
   z_fen=z(i-m:i+m-1)';
   X=[x_fen y_fen z_fen];
   X_med=X(m-p:m+p,:);
   X_init=X(m-p:  m-1,:);
   X_term=X(m+1:m+p,:);
   X_init1=X(1:m,:);
   X_term1=X(m:2*m,:);
   u_init=max(max(abs(X_init)));
   u_term=max(max(abs(X_term)));
   u_med=max(max(abs(X_med)));
   if u_med<epsilon
         C(i-m)=0;
      else
         if u_init<epsilon
            Y=cov(X_term1);
         else 
            if u_term<epsilon 
               Y=cov(X_init1);
            else
               Y=cov(X);
            end;
         end;
      S=svd(Y);
      a=S(1);
      b=S(2);
      C(i-m)=1-b/a;
   end;
   
end; 
C=[zeros(1,2*m) C]; 

   