function [U,D,V]=prolate(t0,tau,omega0)

% [U,D,V]=prolate(t0,tau,omega0);
%Calcule les valeurs propres de l'operateur L^(t_0,omega_0)
%lorsque l'intervalle [-t0,t0] est echantillone avec un pas tau
%Les valeurs propres lambda de l'operateur (positives) sont 
%en ordre decroissant: D=diag(lambda_1, lambda_2,...).
%Les colonnes de U sont les vecteurs propres (normalises) 
%correspondants. 
%Pour des raisons pratiques, 2t_0/tau<= 256.
 
t=-t0:tau:t0;
l=length(t); 
A=ones(l,l);
for k1=1:l,
  for k2=1:l,
    A(k1,k2)=tau*sinc(2*(k1-k2)*tau*omega0/pi)*(omega0/pi);
  end
end
[U,D,V]=svd(A);

