function B = radonatt(I,Theta,A);

%                  B=radonnat(I,Theta,A) 
% Calcule la transformee de Radon attenuee (sinogramme) d'une image 
% carree I de support dans [-1,1]^2 lorsque l'attenuation est 
% donne par l'image A (I et A sont des images carrees de meme taille). 
% Les angles sont exprimes en degres entiers (entre 0 et 359).  


[M,M]=size(I);
l=length(Theta);
B=[]; 
for k=1:l
    Arot=imrotate(A,-Theta(k),'crop');
    Irot=imrotate(I,-Theta(k),'crop');
    S=radonatt_aux(Arot)/M ;
    Irot=Irot.*exp(-S);
    B=[B,(sum(Irot)*2/M)']; 
end

    





 


            