function B= radonatt0(I,Theta,c);

%                  B=radonnat0(I,Theta,c) 
% Calcule la transformee de Radon attnue (sinogramme) d'une image carree I de
% support dans [-1 1]^2 tronquee au disque unite avec attenuation constante egale  c.  
% Les approximations sont valides pour c entre 0 et 1.5.  
% Les angles sont exprimes en 
% degres (entre 0 et 179).  


[M,M]=size(I);
l=length(Theta); 
tau=2/M ; 
D=disque(1,tau);
x=-1:tau:1-tau ;
y=-1:tau:1-tau ;
X=ones(M,1)*x ; 
Y=y'*ones(1,M); 
I=I.*D ;
IX=I.*X ;
IY=I.*Y ;
IXX=IX.*X ;
IXY=IX.*Y ;
IYY=IY.*Y ;
IXXX=IXX.*X ;
IXXY=IXX.*Y ;
IXYY=IYY.*X ;
IYYY=IYY.*Y ;
R=radon(I,Theta);
[Ns,P]=size(R);
sigma=2/Ns ; 
s=-1:sigma:1-sigma ;
e=exp(c*s);
ee=exp(-c* sqrt(1-s.^2));
E=ee'*ones(1,l) ;
SIGN=(sign(s))'*ones(1,l);
COS=ones(Ns,1)*cos(pi*Theta/180);
SIN=ones(Ns,1)*sin(pi*Theta/180);
RX=radon(IX,Theta);
RY=radon(IY,Theta);
RXX=radon(IXX,Theta);
RXY=radon(IXY,Theta);
RYY=radon(IYY,Theta);
RXXX=radon(IXXX,Theta);
RXXY=radon(IXXY,Theta);
RXYY=radon(IXYY,Theta);
RYYY=radon(IYYY,Theta);
p=polyfit(s,e,3);
B=p(4)*R -p(3)*c*SIGN.* (SIN.* RX-COS.*RY); 
B=B+p(2)*(c.^2)*((SIN.^2).*RXX-2*COS.*SIN.*RXY+(COS.^2).*RYY);
B=B-p(1)*(c.^3)*SIGN.*((SIN.^3).*RXXX-3*(SIN.^2).*COS.*RXXY+3*(COS.^2).*SIN.*RXYY-(COS.^3).*RYYY); 
B=E.*B ; 


 


            