function B = radonatt1(I,Theta,c,x0,y0);

%                  B=radonnat1(I,Theta,c,x0,y0) 
% Calcule la transformee de Radon attnue (sinogramme) d'une image carree I de
% support dans [-1 1]^2 tronquee au disque unite lorsque l'attenuation est
% gale  c fois la masse de Dirac au point (x0,y0) du disque unit. 
% Les angles sont exprimes en 
% degrs (entre 0 et 179).  


[M,M]=size(I);
l=length(Theta); 
tau=2/M ; 
D=disque(1,tau);
I=I.*D ;
x=-1:tau:1-tau ;
y=-1:tau:1-tau ;
X=ones(M,1)*x ; 
Y=y'*ones(1,M); 
COS=cos(Theta*pi/180);
SIN=sin(Theta*pi/180);
B=[];
for k=1:l
    S=COS(k)*X + SIN(k)*Y ; 
    U0=(-SIN(k)*x0+COS(k)*y0)*ones(M);
    U=(-SIN(k)*X + COS(k)*Y)-U0 ; 
    V=sign(S).*(sign(U)+1)/2 ;
    II=exp(-c*V).*I ; 
    R=radon(II,Theta(k)); 
    B=[B,R];
end





 


            