function B = radonbis(R,tau,sigma,A);

%                  B=radonbis(R,tau,sigma,A) 
% Calcule la transformee de Radon (sinogramme) d'une image A=A(-R:tau:R-tau,-R:tau:R-tau)
% apres l'avoir tronque pour la localiser dans D(0,R)
% La sortie B(theta,p) est une image du type 
% B(theta,p)= B(0:sigma:2*pi, -R:p:R-tau)

D=disque(R,tau);
A=D.*A;
x=-R:tau:R-tau;
MM=length(x); 
x=x';
a=ones(1,MM); 
XX=x*a;
YY=a'*x';
theta=0:sigma:2*pi; 
M=length(theta);
p=-R:tau:R-tau;
B=zeros(M,MM); 

%Indice de comptage 
N=0; 

for i=1:M
   for j=1:MM
      Q=cos(theta(i))*XX+ sin(theta(i))*YY+(R-(j-1)*tau)*ones(MM);
      [I,J]=find(abs(Q)<tau/2);
      B(i,j)=tau*sum(diag(A(I,J)));
   end
   N=N+1; 
   N
end


            