function f=reassign(h2d,I,epsilon);

% f=reassign(h2d,I,epsilon);
% Etant donnee une image reelle I et une densite h2d 
% cette fonction calcule la version reassignee de 
% I relativement au poids h2d. Le seuil epsilon est 
% le seuil en dessous duquel il n'est pas procede au
% reassignement (si |h2d*I (x,y)| <= epsilon, la valeur 
% 0 est assignee au point (x,y)). 

[N1,N2]=size(I);
I=real(I);
reassign=zeros(N1,N2);
vt=1:size(I,2);
vf=1:size(I,1);
prw=vpm(vf,I);
prt=vpm(vt,I'); 
prt=prt';
nt=conv2(prt,h2d,'same');
nw=conv2(prw,h2d,'same');

Ifilt=conv2(I,h2d,'same');
for n=1:N1
  for m=1:N2
      if( abs(Ifilt(n,m))>epsilon )
        nn=nt(n,m)/Ifilt(n,m);
        nn1=round(abs(nn));
        nm=nw(n,m)/Ifilt(n,m);
        nm1=round(abs(nm));
        if (nm1>N1-1) nm1=N1; end;
        if (nn1>N2-1) nn1=N2; end;
        if (nn1<1) nn1=1; end;
        if (nm1<1) nm1=1; end;
        reassign(nm1,nn1)=reassign(nm1,nn1)+Ifilt(n,m);
      end;
  end;
end;
f=reassign;
