function [R,D]=res22(a) 
% [R,D]=res22(a) 
% Calcule les matrices R et D correspondant 
% aux spectres des filtres intervenant 
% dans l'exercice 6.2.1 avec p=2. Ces matrices 
% sont a lire avec les algorithmes plmat30
% ou immat30. Pour enchainer divers operateurs 
% du type R_p ou D_p (p=2,3,5), il convient 
% d'utiliser le programme de multiplication des 
% matrices moltay. Ici a designe le pas de 
% l'echantillonnage de [0, 2*pi] requis. 

i=0:a:2*pi;
h=length(i);
s=ones(1,h);
U1=zeros(15,15*h);
V1=zeros(15,15*h);
U2=zeros(15,15*h);
V2=zeros(15,15*h);
U3=zeros(15,15*h);
V3=zeros(15,15*h);
U4=zeros(15,15*h);
V4=zeros(15,15*h);

for j=1:15
  l=i+(pi*(j-1)/15);
  m=(cos(l/2)).^2.*sqrt((2+cos(l))./(2+cos(2*l)));
  m1=sqrt(1-m.^2);
  U1=fillay(U1,j,j,m.^2);
  V1=fillay(V1,j,j,1-m.^2);
  U2=fillay(U2,j,j,m.*m1);
end;
V2=-U2;
for j=16:30
  l=i+(pi*(j-1)/15);
  m=(cos(l/2)).^2.*sqrt((2+cos(l))./(2+cos(2*l)));
  m1=sqrt(1-m.^2);
  U4=fillay(U4,j-15,j-15,m.^2);
  V4=fillay(V4,j-15,j-15,1-m.^2);
  U3=fillay(U3,j-15,j-15,m.*m1);
end;
V3=-U3;
R=[U1,U2; U3,U4];
D=[V1,V2;V3,V4];


