function f=retroproj(R,tau,sigma,B); 

%             f=retroproj(R,tau,sigma,B); 
%Calcule l'inversion de la transformee de Radon A d'une image 2D  
%A=A(-R:tau:R-tau,-R:tau:R-tau) par retroprojection; le pas angulaire 
%est fixe egal a sigma; l'entree B est la transformee de Radon du 
%signal s calculee selon B=radon(R,tau,sigma,A) (eventuellement bruitee).  

[M,MM]=size(B);
C=zeros(M,MM); 
C(:,1)=(B(:,2)-B(:,1))/tau;
C(:,MM)=(B(:,MM)-B(:,MM-1))/tau;
B1=B(:,3:MM);
B2=B(:,1:MM-2);
CC=B1-B2;
C(:,2:MM-1)=CC/(2*tau); 
U=spectremat(C,R);
MMM=fix(MM/2);
w1=- i* ones(M,MMM);
w2=i*ones(M,MM-MMM);
w=[w1 w2]; 
UU=w.*U;
h=hamming(MM);
H=zeros(M,MM);
for k=1:M
   H(k,:)=hamming(MM)';
end
Omega=pi/tau; 
BB=real(ispectrmat(UU,Omega));

% indice de comptage 
N=0;

theta=0:sigma:2*pi;
a=ones(1,MM);
x=-R:tau:R-tau;
x=x';
XX=x*a;
YY=a'*x';
L=zeros(MM,MM);
Laux=zeros(MM,MM);
for i=1:M;
   Q=(cos(theta(i))*XX+ sin(theta(i))*YY+R*ones(MM))/tau;
   Q=max(Q,zeros(MM));
   Q=min(Q,(MM-1)*ones(MM));
   QQ=round(Q+ones(MM));
   for k=1:MM
      for l=1:MM
         Laux(k,l)=BB(i,QQ(k,l));
      end
   end
   L=L+Laux;
   N=N+1;
   N
end
f=(1/(4*pi))*L*sigma;
         
   
   
   
   
   
