function f=rpyramid(s,a);

% f=rpyramid(s,a);
% Decimation + filtrage 
% avec un filtre 
% h(0)=a, h(1)=h(-1)=1/4 
% h(2)=h(-2)=1/4-a/2
% h(k)=0 pour abs(k) plus grand que 3.
% pour une entree de longueur 2^q+1, 
% l'algorithme genere une sortie de 
% longueur 2^(q-1)+1. 

 
m=length(s);
h=trunc(m);
x=s.*h;
M=fix(m./2);
b=(1/4)-(a/2);
c=(a+1)/2;
j=1:(M+1);
z(j)=j;
z(1)=(1/c)*(a*(s(1))+(1/4)*(s(2))+b*(s(3)));
z(M+1)=(1/c)*(a*(s(m))+(1/4)*(s(m-1))+b*(s(m-2)));
k=1:(M-1);
z(k+1)=a*(s(2*k+1))+(1/4)*(s(2*k)+s(2*k+2))+b*(s(2*k-1)+s(2*k+3));
f=z;
