function f=spectre2(I,X,Y);

% f=spectre2(I,X,Y);
% Calcule, etant donne une image I=I(x,y) 
% x=-X:X/M1:X-X/M1,
% y=-Y:Y/M2:Y-Y/M2, 
% le spectre approche de I aux points 
% (omega1,omega2),ou 
% omega1=k1* pi/X, k1=-M1:1:M1-1
% omega2=k2*pi/Y, k2=-M2:1:M2-1

[N1,N2]=size(I);
 M1=fix(N1/2);
 M2=fix(N2/2);
l1=0:1:N1-1;
l2=0:1:N2-1;
w1=cos(l1*pi);
w2=cos(l2*pi);
w=w1'*w2;
U=fft2(I);
U=w.*U;
U1=U(1:M1,1:M2);
U2=U(1:M1,M2+1:N2);
U3=U(M1+1:N1,1:M2);
U4=U(M1+1:N1,M2+1:N2);
V=[U4 U3;U2 U1];
f=V;
f=((4*X*Y)/(N1*N2))*f;


