function [D,etiq,sp]=split(s,M,m);

% [D,etiq,sp]=split(s,M,m);
%Realise l'algorithme SPLIT sur un signal de 
%longueur (2^M+1)*2^m; 2^m represente le pas 
%de chevauchement des fenetres. Les atomes de 
%la decomposition sont donnes dans D (suivant 
%l'ordre lexicographique echelles-temps, les 
%echelles etant rangees dans l'ordre croissant). 
%La ligne sp(i,:) represente le spectre de l'atome
%fenetre D(i,:) positionne dans la meme fenetre; 
%La fenetre supportant D(i,:) correspond en ce qui 
%concerne la lecture sur l'echelle des frequences 
%a l'intervalle [0 pi/tau], ou tau est le pas 
%d'echantillonnage du signal. Pour connaitre le 
%niveau d'echelle ou se situe une ligne de D dans la 
%decomposition, on doit lui faire correspondre 
%le numero correspondant dans la colonne etiq.  


D=[];
sp=[];
etiq=[];

if M==1, 
   [e,ws,sp]=malvar_aux(s,1,m);
   D=ws;
   etiq=1;
   sp=[sp zeros(1,2^m)];
else
   N=(2^M+1)*2^m;
   NN=(2^(M-1)+1)*2^m;
   s1=s(1:NN);
   s2=s(NN-2^m+1:N);
   [e1,ws1,sp1]=malvar_aux(s1,M-1,m);
   [e2,ws2,sp2]=malvar_aux(s2,M-1,m);
   [e0,ws0,sp0]=malvar_aux(s,M,m);
   
   if e1+e2<e0
      [D1,etiq1,sp1]=split(s1,M-1,m);
      [D2,etiq2,sp2]=split(s2,M-1,m);
      l1=size(D1);
      l2=size(D2);
      D1=[D1 zeros(l1(1),N-NN)];
      D2=[zeros(l2(1),N-NN) D2];
      D=[D;D1;D2];
      sp1=[sp1 zeros(l1(1),N-NN)];
      sp2=[zeros(l2(1),N-NN) sp2];
      etiq=[etiq;etiq1;etiq2];
      sp=[sp;sp1;sp2];
   else 
      l=size(D);
      D=[D; ws0];
      etiq=[etiq;M];
      sp0=[sp0 zeros(1,2^m)];
      sp=[sp;sp0];
   end;
   
end;
