function f=totfrank(x);

% Ce programme permet de traiter un signal (donne en ligne) 
% suivant l'algorithme correspondant a la decomposition de 
% Franklin en le decoupant en des fenetres consecutives 
% de 1025 points. La sortie consiste en la liste des 
% six details (en ligne) d1 d2 d3 d4 d5 d6, suivie du resume r6.  
% d1 est affine par morceaux toutes les unites, 
% d2 est affine par morceaux toutes les 2 unites,
% d3 ,,    ,,    ,,    ,,      ,,    ,, 4 unites,
% d4 ,,    ,,    ,,    ,,      ,,    ,, 8 unites,
% d5 ,,    ,,    ,,    ,,      ,,    ,, 16 unites,
% d6 ,,    ,,    ,,    ,,      ,,    ,, 32 unites,
% r6 ,,    ,,    ,,    ,,      ,,    ,, 64 unites. 

N=length(x);
M=fix(N/1025);
f=[];
u=zeros(7,1);
u1=[];
u2=[];
J=1;
for i=1:M
  y=x(J:J+1025-1);
  r1=franklin(0,10,y);
  r2=franklin(1,10,r1);
  r3=franklin(2,10,r2);
  r4=franklin(3,10,r3);
  r5=franklin(4,10,r4);
  r6=franklin(5,10,r5);
  d1=y-r1;
  d2=r1-r2;
  d3=r2-r3;
  d4=r3-r4;
  d5=r4-r5;
  d6=r5-r6;
  d=[d1;d2;d3;d4;d5;d6;r6]; 
  u1=d(:,1);
  dd=d(:,2:1025);
  u2=(u+u1)/2;
  d=[u2 dd];
  [m1,m2]=size(f);
  f1=f(:,1:m2-1);
  f=[f1 d];
  u=d(:,1025);
  J=J+1025-1;
end

