function viewpack(U,etiq,m);

%  viewpack(U,etiq,m)
%permet la visualisation de la decomposition en 
%paquets d'ondelettes (analyse multiresolution 
%de Daubechies a 4 ou 8 parametres); on prend
%[U,etiq]=wpackM(s) avec M=4 ou 8; m est le nombre 
%de composants par figure. 

[nr nc]=size(U);
t=1:nc;
if m>nr
	figure
	for i=1:nr
		subplot(nr,1,i)
      plot(t,U(i,:))
      m1=max(abs(U(i,:)));
      text(10,m1/2,etiq(i,:))
      axis([1 nc -m1 m1])
	end;
else
	r=fix(nr/m);
	for l=1:r
		figure
		for i=1:m
			subplot(m,1,i)
         plot(t,U(((l-1)*m+i),:))
         m1=max(abs(U((l-1)*m+i,:)));
         text(10,m1/2,etiq((l-1)*m+i,:))
         axis([1 nc -m1 m1])
		end;	
	end;
	reste=nr-r*m;
	if reste ~= 0
		figure
		for i=1:reste
			subplot(reste,1,i)
         plot(t,U((m*r+i),:))
         m1=max(abs(U(m*r+i,:)));
         text(10,m1/2,etiq(m*r+i,:))
         axis([1 nc -m1 m1])
		end;	
	end;	
end;

