function f=wfft(h,s);

% f=wfft(h,s); 
% Calcule le spectre fenetre d'un signal s 
% (algorithme WDFT) a travers une fenetre h 
% donnee en ligne, avec H=length(h)<length(x).  
% La sortie est une matrice (H,N), ou les  
% abscisses n entre 1 et N decrivent la position 
% de la fenetre et les ordonnees le domaine frequentiel 
% [0,pi/tau], tau etant le pas d'echantillonnage temporel.  
% Le signal est remplace par la transformee de Hilbert  
% de sa partie reelle dans la fenetre glissante. 

N=length(s);
H=length(h);
m=fix(H/2);
A=ones(N-H,H);
for j=(H+1):N,
y=s(j-H:j-1);
z=hilbert(y);
z1=h.*z;
for k=1:H,
A(j-H,k)=z1(k);
end
end

B=(1/H)*abs(fft(conj(A'),H));
f=B(1:m,:);
%C=ones(m,N-H);
%for l=1:m;
%C(m+1-l,:)=B(l,:);
%end

%f=B;
