function f=wig0(s);

% f=wig0(s);
%Calcule la transformee de Wigner-Ville discrete 
%Le signal (echantillonne avec un pas tau) 
%est prolonge par 0 aux fenetres 
%laterales. L'entree est un vecteur ligne. L'abscisse 
%est le temps; l'axe des ordonnees est l'axe des frequences. 
%Le domaine de frequences est [0, 2pi/tau], avec la convention 
%qu'un reel x entre pi et 2pi correspond a la frequence x-(2pi/tau) 

x1=s';
N=length(s);
y=[zeros(N,1); x1; zeros(N,1)];
A=[];
T1=ones(N,1);
T2=ones(N,1);

for k=1:N,
  T1=y((N+2-k):(2*N+1-k));
  T2=conj(y((N+k):(2*N+k-1)));
  T=T1.*T2;
  A=[A T];
end
 
f=fft(A');