function f=wigh(s);

% f=wigh(s);
%Calcule la transformee de Wigner-Ville discrete 
%Le signal (echantillonne avec un pas tau) 
%est repete par periodisation aux fenetres 
%laterales. L'entree est un vecteur ligne. L'abscisse 
%est le temps; l'axe des ordonnees est l'axe des frequences. 
%Le signal est remplace par la transformee de Hilbert 
%de sa partie reelle. Le domaine de frequences est [0, 2pi/tau].

u=hilbert(s);
x1=u';
N=length(u);
y=[x1; x1; x1];
A=[];
T1=ones(N,1);
T2=ones(N,1);

for k=1:N,
  T1=y((N+2-k):(2*N+1-k));
  T2=conj(y((N+k):(2*N+k-1)));
  T=T1.*T2;
  A=[A T];
end
 
g=fft(A');
f=real(g);
f=flipud(f);
