function f=wiglis1h(h2d,s);

% f=wiglis1h(h2d,s);
%Calcule la transformee de Wigner-Ville discrete lissee 
% par une fenetre h2d. 
%Le signal (echantillonne avec un pas tau et 
%remplace par la transformee de Hilbert de sa partie reelle) 
%est repete par periodisation aux fenetres 
%laterales. L'entree est un vecteur ligne. L'abscisse 
%est le temps; l'axe des ordonnees est l'axe des frequences. 
%Le domaine de frequences est [0, pi/tau].  

I=wigh(s);
a=sum(sum(h2d));
g=(1/a)*conv2(I,h2d,'same');
m=size(g);
for k=1:m(1),
   f(k,:)=g(m(1)+1-k,:);
end
f=flipud(f);
